# System Test/ Smoketest

## Intention
System Test Functions to evaluate the proper function of
* Mover
* Excitation Light Sources: Flashlamp, TRF-Laser, Alpha Laser
* Detectors: Photodiodes, PMTs
* Temperature Control Elements: Fans, Peltiers, Heating Mats, Temp.-Sensors
Before Integration into the whole system
Smoke-Test: First Power-On Test with all modules integrated

## Structure and Scripts
mover_test.py: Movertest:
          xx_move(cycles): Moves Mover for cycle times and returns Step-Deviation
            xx:
              fms - FiltermoduleSlider, 
              fm - FocusMover
              pd - PlateDoor,
              st - ScanTable,
              das1 - DetectorApertureSlider1,
              das2 - DetectorApertureSlider2,
              els - ExcitationLightSelector,
              bld - BottomLightDirector
   tc_test.py: Temperature Control Tests
  bcr_test.py: BarcodeReader Tests

## Report
Each test shall generate a report with detailed test results.
_(not yet implemented)_

### Format: *.rep
2021-03-09 - pyrunner000: ...Test 
Timestamp                   Control     Component   Ref Value   Result Value    Deviation
-----------------------------------------------------------------------------------------
2021-03-09 17:00:07,200     fmb         fan 1       ok          ok              0
                            eef         pmt 1       >100000      500            99500

## Test Result Values
The following parameter values are intended to evaluate the modules

### Mover
Step Error: return value from homing procedure after a specific count of movement cycles

### Temperature Control Tests
TEC Test: Kelvin/Minute
Lower/Upper Heating: Kelvin/Minute
Temp.-Sensors
Fans

### Barcode Reader Tests

== Not Implemented yet ====

### Excitation Light Sources
Reference PD readout after specific pulse-duration
TRF-Laser: return-String of Query '*IDN?':
'Coherent, Inc - FlareNX Controller - Serial LDP.1415528.W00001 - V3.0.20 - 2020 Jun 09'
### Detector
PMT: Darkcount (all LEDs off, housing closed, Aperture closed)
Ref PD: 14..18*10^6 (Predefined Tasks: els_flash1)
Abs PD: 200..300*10^6
